module srisc1(clock,pc,npc,ireg,reset,da,db,dc,ra,rb,rc,oal,mq,RegWrite,MemWrite,state);
input clock,reset;
output [7:0] pc,npc;
output [31:0] ireg;
output [31:0] da,db,dc;
output [4:0] ra,rb,rc;
output RegWrite,MemWrite;
output [1:0] state;
output [31:0] oal;
output [31:0] mq;

wire [7:0] wpc,npc,nextpc;
reg [7:0] pc;

// instantiate instruction memory
wire is_exe,mem_op;
assign is_exe = (state==exe);
assign mem_op = Lw || Sw;
assign wpc = (mem_op && !is_exe)? pc: npc;
inst instruction_cache(
	.address(wpc),
	.clock(clock),
	.q(ireg)
);

wire [31:0] md,mq;
assign md = db;

// instantiate data memory
mem2 data_cache(
	.address(oal[9:2]),
	.clock(clock),
	.data(md),
	.wren(MemWrite),
	.q(mq)
);


// instantiate register file
reg_file regs(
	.clock(clock),
	.reset(reset),
	.da(da),
	.db(db),
	.dc(dc),
	.ra(ra),
	.rb(rb),
	.rc(rc),
	.write_enable(RegWrite)
	);

wire [31:0] dmi;
wire [5:0] control;
wire [2:0] aluc;
wire [1:0] muxi_control;
wire call, jmpr, branch, cmp, do_branch;
wire zero, neg, ovfl;

wire [31:0] oal, obs;
	
// instantiate alu
alu my_alu(
	.a(da),
	.b(dmi),
	.control(aluc),
	.c(oal),
	.zero(zero),
	.neg(neg),
	.ovfl(ovfl)
	);
	
// instantiate barrel shifter
wire [4:0] shift;
assign shift = (control[3]? shf: db[4:0]);
barrel brl(
	.inp(da),
	.control(control[2:0]),
	.shift(shift),
	.out(obs)
	);
	
// comparison logic
assign cmp = (control[1]? neg: zero)^control[0];
	
// instantiate immed multiplexer
muxi mux1(
	.dst(dmi),
	.b(db),
	.immed(immed),
	.immedse(immedse),
	.control(muxi_control)
	);
	
// instantiate dc-bus multiplexer
wire [2:0] muxd;
muxc mux2(
	.oal(oal),
	.obs(obs),
	.cmp(cmp),
	.nextpc(nextpc),
	.data(mq),
	.control(muxd),
	.out(dc)
	);

// instantiate r-format control unit
wire [5:0] rcontrol;
rformat unit1(
	.opx(opx),
	.control(rcontrol)
	);

	
// instantiate i-format control unit
wire [5:0] icontrol;
wire [1:0] muxc;
wire ibranch;
iformat unit2(
	.op(op),
	.control(icontrol),
	.muxc(muxc),
	.branch(ibranch)
	);

// add (|reg) so we don't allow zero-valued instruction to be interpreted as a "call"
assign call = iflag && (op==6'h00) && (|ireg);
assign jmpr = &muxd; // jmpr = (control[5:3] == 3'b111)
assign do_branch = branch&&cmp;
assign nextpc = pc+8'h01;
wire [11:0] rpc;
// the next line assumes that the entry point main is offset by 0x30
assign rpc = (call?{ireg[15:6],2'b00}:da[11:0]) - 12'h030;
assign npc = (call||jmpr)? rpc[9:2]: (nextpc+(do_branch?immedse[9:2]:8'h00));

// Load/Store
wire Lw,Sw;
assign Lw = muxd==3'b100;
assign Sw = muxd==3'b101;

wire RegWrite, MemWrite;
assign RegWrite = !(branch||Sw);
assign MemWrite = (state==store);

// state machine
parameter is_reset = 2'b00, 
		decode = 2'b01,
		   exe = 2'b10,
		 store = 2'b11;
reg [1:0] state;
always @(posedge clock or negedge reset)
begin
if (!reset) state <= is_reset;
else case(state)
is_reset:
	begin
		pc <= 8'hff;		
		state <= decode;
	end
decode:
	begin
		if (Lw) state <= exe;
		else if (Sw) state <= store;
		else 
		begin
			pc <= npc;
			state <= decode;
		end
	end
store: 
	state <= exe;
exe:
	begin
		pc <= npc;
		state <= decode;
	end
default:
	state <= decode;
endcase
end

wire [5:0] op, opx;
wire [15:0] immed;
wire [31:0] immedse;
wire [4:0] shf;
assign op = ireg[5:0];
assign ra = ireg[31:27];
assign rb = ireg[26:22];
assign opx = ireg[16:11];
assign shf = ireg[10:6];
assign immed = ireg[21:6];
assign immedse = {(immed[15]?16'hffff:16'h0000),immed};

wire iflag;
assign iflag = (op!=6'h3a);
assign rc = (call? 5'h1f: (iflag? rb: ireg[21:17]));
assign branch = (iflag? ibranch: 1'b0);

assign control = (iflag? icontrol: rcontrol);
assign muxd = control[5:3];
assign aluc = (muxd==3'b001)? {1'b0,control[2],1'b1}: control[2:0];
assign muxi_control = (iflag? muxc: 2'b00);


endmodule
