/*
*   control:
*    00  b
*    01  immedse, (immed sign-extended)
*    10  {16'h0000, immed} (not sign-extended)
*    11  {immed, 16'h0000}
*/
module muxi(dst,b,immedse,control);
parameter BITS = 32;
input [BITS-1:0] b, immedse;
input [1:0] control;
output [BITS-1:0] dst;

reg [BITS-1:0] dst;

always
	case (control)
	2'b00: dst = b;
	2'b01: dst = immedse;
	2'b10: dst = {16'h0000, immedse[15:0]};
	2'b11: dst = {immedse[15:0],16'h0000};
	endcase
endmodule