module srisc2(input clock, input reset, output reg [7:0] pc, output [31:0] ir, output [31:0] results);

wire [31:0] da, db, dc;
wire [4:0] ra, rb, rc;
wire write_enable;

// instantiate memory
wire [7:0] next_pc;
inst inst_cache(
	.address(next_pc),
	.clock(clock),
	.q(ir)
);

assign next_pc = pc + 1'b1;

always @(posedge clock or negedge reset)
	if (!reset) 
		pc <= 8'hff; // so that next_pc starts at zero
	else 
		pc <= next_pc;

// Instantiate register file

reg_file regs(
	.clock(clock),
	.reset(reset),
	.da(da),
	.db(db),
	.dc(dc),
	.ra(ra),
	.rb(rb),
	.rc(rc),
	.write_enable(write_enable)
	);

// decode instruction

wire [5:0] op, opx;
wire [15:0] immed;
assign op = ir[5:0];
assign ra = ir[31:27];
assign rb = ir[26:22];
assign opx = ir[16:11];
assign shf = ir[10:6];
assign immed = ir[21:6];

wire iflag;
assign iflag = (op!=6'h3a);
assign rc = (iflag? rb: ir[21:17]);

// This assignment implements mov and movi instructions
assign dc = (iflag? {16'h0000,immed}: da);

assign results = dc; // map C data bus to results

assign write_enable = 1'b1;

endmodule
