/* lights.c
 *
 *  Connect the switches to the LEDs
*/

#include <plib.h>

const int LED1 = BIT_0;
const int LED2 = BIT_1;
const int LED3 = BIT_2;
const int SW1  = BIT_6;
const int SW2  = BIT_7;
const int SW3  = BIT_13;

int main()
{
	int n;
	mPORTDSetPinsDigitalIn(SW1 | SW2 | SW3 );
	mPORTDSetPinsDigitalOut(LED1 | LED2 | LED3);
	while (1) {
		// SW1 -> LED1
		n = mPORTDReadBits(SW1);
		if (n) mPORTDClearBits(LED1);
		else mPORTDSetBits(LED1);
		// SW2 -> LED2
		n = mPORTDReadBits(SW2);
		if (n) mPORTDClearBits(LED2);
		else mPORTDSetBits(LED2);
		// SW3 -> LED3
		n = mPORTDReadBits(SW3);
		if (n) mPORTDClearBits(LED3);
		else mPORTDSetBits(LED3);
	}
	return 0;
}
