#define PIC32
#if defined(PIC32)
	#include <p32xxxx.h>
	// comment the following line to enable debug output
	#define UART2_IO
	#include "db_utils.h"
#else // Microsoft C
	#include <stdio.h>
	#define DBPRINTF printf
	#define DBPUTS(s)
#endif

int main()
{
	unsigned int na, ns, nv;
	na = 0x8000F731;
	DBPRINTF("na = 0x%x\n",na);

	// logical shift left
	nv = na<<3;
	DBPRINTF("na<<3 = 0x%x\n",nv);
	// logical shift right
	nv = na>>3;
	DBPRINTF("na>>3 = 0x%x\n",nv);
	// aritmetic shift right
	nv = ((signed)na)>>3;
	DBPRINTF("((signed)na)>>3 = 0x%x\n",nv);

	// rotate right
	nv = (na>>4)|(na<<28);
	DBPRINTF("rot right 4 = 0x%x\n",nv);

	// rotate left
	nv = (na<<4)|(na>>28);
	DBPRINTF("rot left 4 = 0x%x\n",nv);

	// use variable as shift amount
	ns = 5;
	DBPRINTF("Use variable as shift amount\n ns = %d\n",ns);

	nv = na>>ns;
	DBPRINTF("na>>ns = 0x%x\n",nv);

	nv = na<<ns;
	DBPRINTF("na<<ns = 0x%x\n",nv);

	ns = 8;
	// rotate right
	nv = (na>>ns)|(na<<(32-ns));
	DBPRINTF("rot right 8 = 0x%x\n",nv);

	// rotate left
	nv = (na<<ns)|(na>>(32-ns));
	DBPRINTF("rot left 8 = 0x%x\n",nv);

	DBPUTS("Program terminated. Click HALT and then RESET to stop the microcontroller. \n");
	return 0;
}
