/* bitfield3.c
 *
*/

#include <plib.h>

void wait();

typedef union {
	struct {
		unsigned int LED1: 1;
		unsigned int LED2: 1;
		unsigned int LED3: 1;
	};
	unsigned int w;
} leds_t;



int main()
{
	int i;
	leds_t leds;
	leds.w = 0;
	leds.LED2 = 1;
	mPORTDSetPinsDigitalOut(leds.w);   /* Make selected leds output */
	mPORTDClearBits(leds.w);      /* Turn off selected leds on startup */
	while (1) {
		mPORTDToggleBits(leds.w);     /* Toggle selected leds */
		wait();
	}
	return 0;
}

void wait()
{
	const int DLY = 5000;
	T1CON = 0; // turn timer off and clear all bits
	T1CONbits.TCKPS = 3; // Set prescaller to 1:256
	TMR1 = 0;
	PR1 = 0xFFFF;
	T1CONbits.TON = 1; // start timer
	while (TMR1 < DLY) {
		// just wait
	}
	T1CONbits.TON = 0; // stop timer
}
