# mips4.s illustrates instruction variations

	.global main

	.text

    /* This directive tells the assembler don't optimize
     * the order of the instructions and don't insert
     * 'nop' instructions after jumps and branches.
    */
	.set noreorder

/*********************************************************************
 * main()
 * This is where the PIC32 start-up code will jump to after initial
 * set-up.
 ********************************************************************/

.ent main   # directive that marks symbol 'main' as function in ELF output

main:
	li	$a0,24
	li	$a1,4

adds:
	add	$t0,$a0,$a1
	add	$t0,$a0,6
	add	$t0,$a0,0x1234
	add	$t0,$a0,0x12340000
	add	$t0,$a0,0x12345678

shifts:
	srl	$t0,$a0,$a1
	srl	$t0,$a0,6
	rol	$t0,$a0,$a1
	rol $t0,$a0,8
	ror	$t0,$a0,4

branches:
	bge	$a0,$a1,main
	nop
	bge	$a0,4,main
	nop
	bge	$a0,0x1234,main
	nop
	bge	$a0,0x12340000,main
	nop
	bge	$a0,0x12345678,main
	
	jr   $ra
	nop

.end main   #  directive that marks end of 'main' function 
            # and registers size in ELF output

