# mips3.s illustrates jump instructions

	.global main

	.text

    /* This directive tells the assembler don't optimize
     * the order of the instructions and don't insert
     * 'nop' instructions after jumps and branches.
    */
	.set noreorder

/*********************************************************************
 * main()
 * This is where the PIC32 start-up code will jump to after initial
 * set-up.
 ********************************************************************/

.ent main   # directive that marks symbol 'main' as function in ELF output

main:
	li	$a0,24
	li	$a1,4
	j	first
	nop

second:
	jal	divide_them
	nop
	j	done
	nop

first:
	la	$s2,multiply_them
	jalr	$s1,$s2           # This is bad practice (should use ra)
	nop
	move	$v1,$v0
	j	second
	nop
done:
	li	$t0,0xABCD1234
	li	$t4,8
	rol	$t1,$t0,$t4
	ror	$t2,$t0,$t4
	
	jr   $ra
	nop

multiply_them:
	mul $v0,$a0,$a1
	jr  $s1           # this is bad practice (should use ra)
	nop

divide_them:
	div  $v0,$a0,$a1
	jr   $ra
	nop

.end main   #  directive that marks end of 'main' function 
            # and registers size in ELF output

