# mips2.s illustrates branch instructions

	.global main

	.text

    /* This directive tells the assembler don't optimize
     * the order of the instructions and don't insert
     * 'nop' instructions after jumps and branches.
    */
	.set noreorder

/*********************************************************************
 * main()
 * This is where the PIC32 start-up code will jump to after initial
 * set-up.
 ********************************************************************/

.ent main   # directive that marks symbol 'main' as function in ELF output

main:
	beqz	$a0,done  # macro
	nop
	bnez	$a0,done  # macro
	nop
	bgez	$a0,done  # instruction
	nop
	bgtz	$a0,done  # instruction
	nop
	bltz	$a0,done  # instruction
	nop
	blez	$a0,done  # instruction
	nop
	
	beq	$a0,$a1,done  # instruction
	nop
	bne	$a0,$a1,done  # instruction
	nop
	bgt	$a0,$a1,done  # macro
	nop
	bge	$a0,$a1,done  # macro
	nop
	blt	$a0,$a1,done  # macro
	nop
	ble	$a0,$a1,done  # macro
	nop

	bgtu	$a0,$a1,done # macro
	nop
	bgeu	$a0,$a1,done # macro
	nop
	bltu	$a0,$a1,done # macro
	nop
	bleu	$a0,$a1,done # macro
	nop
	
	b	done           # macro
	nop

done:
	li $a0,-20
	abs $a1,$a0     # macro (absolute value)
	
	move $v0,$a1
	jr   $ra
	nop



.end main   #  directive that marks end of 'main' function 
            # and registers size in ELF output

