%% cube1

%%
close all
clear

%          1      2      3      4      5      6      7      8
vcube = [ 0 0 0; 1 0 0; 1 1 0; 0 1 0; 0 0 1; 1 0 1; 1 1 1; 0 1 1]';
idx = [1 2 3 4 1 5 6 7 8 5 6 2 3 7 8 4];
vert(1,:) = vcube(1,:)*6;  % width 6 ft.
vert(2,:) = vcube(2,:)*6; % length 6 ft.
vert(3,:) = vcube(3,:)*6;  % height 6 ft.

x = vert(1,idx);
y = vert(2,idx);
z = vert(3,idx);

%%

close all
plot3(x,y,z,'k-');
arrows;

%hold on
campos([-8 -15 9]);
camtarget([3 0 3]);
camup([0 0 1]);
camva(40);
camproj('perspective');
%set(gcf,'renderer','zbuffer')
axis equal
axis off
set(gcf,'Position',[100 100 640 640]);
set(gca,'Position',[0 0 1 1]);
str = 'DataAspectRatio';
fprintf('%s: %g %g %g\n',str,get(gca,str));
%hold off

%%

v1 = get(gca,'CameraPosition');
fprintf('camera position: %g %g %g\n',v1);
v2 = get(gca,'CameraTarget');
fprintf('camera target: %g %g %g\n',v2);
up = get(gca,'CameraUp');
fprintf('camera up: %g %g %g\n',up);


%%


f = getframe(gcf);
filename = 'cube1.jpg';
imwrite(f.cdata,filename);

%%

rgb = imread(filename);
imshow(rgb);
