/*
 *	CIF Layer name storage and lookup functions.
 *	See "cif2ps.c" for authors' names and addresses.
 *	Please honor the authors by not removing their attributions.
 */

#include "define.h"
#include <string.h>
#include <malloc.h>


int
layer_lookup(name)	/* assigns a unique number to each CIF layer */
char *name;
{
	int i;
	char *new;

	for (i=0; i<numlayers; i++) {
		if (!strcmp(name,layers[i].name)) return(i);
	}
	/* layer was not found so define it */
	if (numlayers>=MAXLAYERS) {
		fprintf(stderr,"Too many layers\n");
		exit(1);
	}
	new = malloc(LNAMELEN+1);
	if (!new) {
		fprintf(stderr,"layer_lookup: Out of memory\n");
		exit(1);
	}
	layers[numlayers].name = strncpy(new,name,LNAMELEN);
	layers[numlayers].name[LNAMELEN] = '\0';
	layers[numlayers].style = 0;
	return(numlayers++);
}
