#!/bin/csh -f
# shell script to make a color/pattern key for cifplot.
# Run this with an arg list of layer names to produce
# CIF with a box showing each layer (on standard output).

if "$1" == "" then
	sh -c "echo $0\: expecting layer list as arguments. >&2"
	exit(1)
endif

echo "( CIF layer key generated by $0 );"
echo "DS 1 200 1;"
# Write cell definitions, one cell for each layer
set Y=1
foreach L ($argv[1-])
	echo "L $L; B 2 2 1 $Y; 94 $L 1 $Y;"
	@ Y += 2
end
echo "DF;"
echo "C 1;"
echo End
