module nios2lab1(
  // Clock Input (50 MHz)
  input  CLOCK_50,
  //  Push Buttons
  input  [3:0]  KEY,
  //  DPDT Switches 
  input  [17:0]  SW,
  //  7-SEG Displays
  output  [6:0]  HEX0, HEX1, HEX2, HEX3, HEX4, HEX5, HEX6, HEX7,
  //  LEDs
  output  [8:0]  LEDG,  //  LED Green[8:0]
  output  [17:0]  LEDR,  //  LED Red[17:0]
  //  GPIO Connections
  inout  [35:0]  GPIO_0, GPIO_1
);

//  set all inout ports to tri-state
assign  GPIO_0    =  36'hzzzzzzzzz;
assign  GPIO_1    =  36'hzzzzzzzzz;

wire RST;
assign RST = KEY[0];

// Connect dip switches to red LEDS
assign LEDR[17:0] = SW[17:0];

wire [31:0] inport, outport;
assign inport[20:18] = KEY[3:1];
assign inport[17:0] = SW;
assign inport[31:21] = 0;
//assign outport = inport;

// map to 7-segment displays, blank leading zeros
wire [7:0] bctl;
hex_7seg_blanking dsp7(outport[31:28],HEX7,1'b1,bctl[0]);
hex_7seg_blanking dsp6(outport[27:24],HEX6,bctl[0],bctl[1]);
hex_7seg_blanking dsp5(outport[23:20],HEX5,bctl[1],bctl[2]);
hex_7seg_blanking dsp4(outport[19:16],HEX4,bctl[2],bctl[3]);
hex_7seg_blanking dsp3(outport[15:12],HEX3,bctl[3],bctl[4]);
hex_7seg_blanking dsp2(outport[11:8] ,HEX2,bctl[4],bctl[5]);
hex_7seg_blanking dsp1(outport[7:4]  ,HEX1,bctl[5],bctl[6]);
hex_7seg_blanking dsp0(outport[3:0]  ,HEX0,bctl[6],bctl[7]);

// instantiate our cpu
cpu1 cpu1(
    // 1) global signals:
    .clk(CLOCK_50),
    .reset_n(RST),

     // the_pio_0
     .in_port_to_the_pio_0(inport),
     .out_port_from_the_pio_0(outport)
    );

endmodule