module hex_7seg_blanking(
	input [3:0] hex_digit,
	output [6:0] seg, 
	input blank_in,
	output blank_out
);

reg [6:0] segm;
// segm = {g,f,e,d,c,b,a};
// 0 is on and 1 is off

always @ (hex_digit)
case (hex_digit)
		4'h0: segm = 7'b1000000;
		4'h1: segm = 7'b1111001; 	// ---a----
		4'h2: segm = 7'b0100100; 	// |	  |
		4'h3: segm = 7'b0110000; 	// f	  b
		4'h4: segm = 7'b0011001; 	// |	  |
		4'h5: segm = 7'b0010010; 	// ---g----
		4'h6: segm = 7'b0000010; 	// |	  |
		4'h7: segm = 7'b1111000; 	// e	  c
		4'h8: segm = 7'b0000000; 	// |	  |
		4'h9: segm = 7'b0011000; 	// ---d----
		4'ha: segm = 7'b0001000;
		4'hb: segm = 7'b0000011;
		4'hc: segm = 7'b1000110;
		4'hd: segm = 7'b0100001;
		4'he: segm = 7'b0000110;
		4'hf: segm = 7'b0001110;
endcase

wire [6:0] blank = 7'b111_1111;

assign blank_out = (hex_digit==4'b0000) && blank_in;
assign seg = (blank_out? blank: segm);

endmodule
