xp = linspace(-1,1,512);
x = ones(size(xp))'*xp;
y = xp'*ones(size(xp));
d = 0.4;
xc = d*[ 0.0  -cos(pi/6)  cos(pi/6)];
yc = d*[ 1.0  -sin(pi/6) -sin(pi/6)]-0.1;
a = sqrt((x-xc(1)).^2+(y+yc(1)).^2)<0.6;
b = sqrt((x-xc(2)).^2+(y+yc(2)).^2)<0.6;
c = sqrt((x-xc(3)).^2+(y+yc(3)).^2)<0.6;
%r1 = max(find(xp<-0.7));
%r2 = min(find(xp>0.7));
%a = a(r1:r2,:);
%b = b(r1:r2,:);

% generate outlined box
sz = size(a);
u = ones(sz);
u(1:2,:)=0;
u(:,1:2)=0;
u(sz(1)-(0:1),:)=0;
u(:,sz(2)-(0:1))=0;

% generate edge images
se = strel('disk',2);
ae = a - imerode(a,se);
be = b - imerode(b,se);
ce = c - imerode(c,se);

ue = double(and(u,~(ae|be|ce)));


% generate example venn diagram
z = xor(xor(a,b),c);
rgb = cat(3,ue,ue,and(ue,~z));
imshow(rgb);

