xp = linspace(-1,1,256);
x = ones(size(xp))'*xp;
y = xp'*ones(size(xp));
a = sqrt((x+0.3).^2+y.^2)<0.6;
b = sqrt((x-0.3).^2+y.^2)<0.6;
r1 = max(find(xp<-0.7));
r2 = min(find(xp>0.7));
a = a(r1:r2,:);
b = b(r1:r2,:);

% generate outlined box
sz = size(a);
u = ones(sz);
u(1:2,:)=0;
u(:,1:2)=0;
u(sz(1)-(0:1),:)=0;
u(:,sz(2)-(0:1))=0;

% generate edge images
se = strel('disk',2);
ae = a - imerode(a,se);
be = b - imerode(b,se);

ue = double(and(u,~(ae|be)));

% generate example venn diagram
z = xor(a,b);
rgb = cat(3,ue,ue,and(ue,~z));
imshow(rgb);

