/*
*   control:
*    000  add, signed
*    001  subtract, signed
*    010  add, unsigned
*    011  subtract, unsigned
* --------------------------------------------
*    100  AND
*    101  OR
*    110  XOR
*    111  NOR
*/  
module alu(a,b,control,c,zero,neg,ovfl);
parameter BITS = 32;
input [BITS-1:0] a, b;
input [3:0] control;
output [BITS-1:0] c;
output zero, neg, ovfl;

wire subtract;
assign subtract = control[0];

// add-subtract unit
wire [BITS-1:0] sum;
wire [BITS-1:0] bn;
wire cin, cout;
assign cin = subtract;
assign bn = (subtract? ~b: b);
assign {cout, sum} = a+bn+cin;

// logic unit
reg [BITS-1:0] out;
always
	case (control[1:0])
	2'b00: out = a&b;
	2'b01: out = a|b;
	2'b10: out = a^b;
	2'b11: out = ~(a|b);
	endcase

wire zero, sgn, unsgn;
assign zero = ~(|sum);
assign sgn  = (sum[BITS-1]? (~a[BITS-1])&(~bn[BITS-1]): a[BITS-1]&bn[BITS-1] );
assign unsgn = cout^subtract;
assign ovfl = (control[1]? unsgn: sgn);
assign neg = (control[1]? unsgn: sum[BITS-1]);

assign c = control[3]? {31'h0,neg}: (control[2]? out: sum);

endmodule
