// Quartus II Verilog Template
// Single Port ROM

module rom1
#(parameter DATA_WIDTH=32, parameter ADDR_WIDTH=8)
(
	input [(ADDR_WIDTH-1):0] address,
	input clock,  
	output reg [(DATA_WIDTH-1):0] q
);

	// Declare the ROM variable
	reg [DATA_WIDTH-1:0] rom[0:2**ADDR_WIDTH-1];

	// Initialize the ROM with $readmemb.  Put the memory contents
	// in the file single_port_rom_init.txt.  Without this file,
	// this design will not compile.
	// See Verilog LRM 1364-2001 Section 17.2.8 for details on the
	// format of this file.

	initial
	begin
		$readmemh("inst.txt", rom);
	end

	always @ (posedge clock)
	begin
		q <= rom[address];
	end

endmodule
