module mrisc1(input clock, input reset, 
	output reg [7:0] pc, output [31:0] ir, 
	output we, output [4:0] rd, output [31:0] results,
	output [4:0] active
);

// instantiate memory
wire [7:0] next_pc;
assign next_pc = pc + 1'b1;

rom1 inst_cache(
	.address(next_pc),
	.clock(clock),
	.q(ir)
);

always @(posedge clock or negedge reset)
	if (!reset) 
		pc <= 8'hff; // so that next_pc starts at zero
	else 
		pc <= next_pc;

// Instantiate register file

wire [31:0] da, db, dc;
wire [4:0] ra, rb, rc;
wire write_enable;

assign {rb, ra} = ID_in[9:0]; 

reg_file regs(
	.clock(clock),
	.da(da),
	.db(db),
	.dc(dc),
	.ra(ra),
	.rb(rb),
	.rc(rc),
	.write_enable(write_enable)
	);

// fetch stage

wire [33:0] IF_out;
reg [31:0] immedse2, immedse3;
wire [31:0] immedse1, jump_target;
assign jump_target = {6'h0,ir[25:0]};
IF_stage stage1(ir,IF_out,immedse1);

// decode stage

reg [33:0] ID_in;
wire [31:0] ID_out;
ID_stage stage2(ID_in,ID_out);

// execute stage

reg [31:0] EX_in;
wire [24:0] EX_out;
wire [31:0] qd;

EX_stage stage3(EX_in,da,db,immedse3,EX_out,qd);

// memory stage

wire [31:0] qm = 0;
reg [24:0] MEM_in;
wire [5:0] MEM_out;

MEM_stage stage4(MEM_in,MEM_out,qd,qm,dc,write_enable);


//----------------------------------------------------------
// send the output of the ALU back to the register file

//assign dc = dalu;
assign rc = MEM_out[4:0];
assign we = write_enable;
assign rd = rc;
assign results = dc; // also send output outside the module for display
assign active = {1'b0, MEM_out[5], EX_out[24], ID_out[31], IF_out[33]};

always @(posedge clock)
begin
	ID_in <= IF_out;
	immedse3 <= immedse2;
	immedse2 <= immedse1;
	EX_in <= ID_out;
	MEM_in <= EX_out;
end

endmodule
