module IF_stage(input [31:0] ir, 
	output [33:0] IF_out, output [31:0] immedse);

wire [5:0] op;
reg [6:0] fn;
reg [4:0] ra,rb,rd;

// COMMON FIELDS
`define RT 20:16
`define RS 25:21
`define OP 31:26
// RFORMAT FIELDS
`define FN 5:0
`define SH 10:6
`define RD 15:11
// IFORMAT
`define IMM 15:0
wire [4:0] shf = ir[`SH];

assign op = ir[`OP];
assign immedse = {(ir[15]?16'hffff:16'h0000),ir[`IMM]};

always
begin
	ra <= ir[`RS];
	if (op>1)
	begin
		rd <= ir[`RT];
		fn <= {1'b0,ir[`FN]};
		rb <= 5'h0;
	end
	else if (op==6'b1)
	begin
		fn <= {1'b1,ir[`FN]};
		rd <= 5'd0;
		rb <= 5'd0;
	end
	else
	begin
		fn <= {1'b0,ir[`FN]};
		rd <= ir[`RD];
		rb <= ir[`RT];
	end
end

wire active = ir != 0;
assign IF_out = {active,shf,fn,op,rd,rb,ra};

endmodule