module ID_stage(input [33:0] ID_in, output [31:0] ID_out);

wire active;
wire [5:0] op;
wire [6:0] fn;
wire [4:0] ra,rb,rd,shf;

assign {active,shf,fn,op,rd,rb,ra} = ID_in;

// instantiate r-format control unit
wire [5:0] rcontrol;
rformat unit1(
	.fn(fn),
	.control(rcontrol)
);
	
// instantiate i-format control unit
wire [5:0] icontrol;
wire [1:0] muxi;
iformat unit2(
	.op(op),
	.control(icontrol),
	.muxi(muxi)
	);

wire flag = (op==0);
wire [5:0] control = (flag? rcontrol: icontrol);
wire [1:0] muxc = (flag? 2'b00: muxi);
assign ID_out = {active,op,fn,shf,control,muxc,rd};

endmodule
