module EX_stage(
	input [33:0] EX_in,
	input [31:0] qa, qb, immedse, 
	output [24:0] EX_out, 
	output [31:0] qd
);
wire active;
wire [5:0] op;
wire [6:0] fn;
wire [4:0] rd,shf;
wire [5:0] control;
wire [1:0] muxc;

assign {active,shf,op,fn,control,muxc,rd} = EX_in;

wire [31:0] dmuxi; // muxi output
muxi mux1(
	.dst(dmuxi),
	.b(qb),
	.immedse(immedse),
	.control(muxc)
	);
	
wire [31:0] dalu; // alu output

wire zero, ovfl;

alu my_alu(
	.a(qa),
	.b(dmuxi),
	.control(control[3:0]),
	.c(dalu)
	);
	
assign qd = dalu;
assign EX_out = {active, op, fn, control, rd};

endmodule