/* tag.h
*
*   tags are used to maintain double-linked lists
*
*/
#if !defined(__TAG_H)
#define __TAG_H

class List;

class Node {
public:
	Node *next;
	Node *prev;
	Node(): next(0), prev(0) { }
	virtual ~Node() { }
	virtual void show() { }
	virtual long size() { return sizeof( Node); }
	friend List;
};

class List {
	Node *top;
	Node *bottom;
	int length;
public:
	List(): top(0), bottom(0), length(0) { }
	~List() { clear(); }

	Node *first() { return top; }
	Node *last()  { return bottom; }
	int count() const { return length; }

	void append(Node *np);
	void prepend(Node *np);
	void clear();
	int index(Node *np);
	void insert(Node *np, int n);
	void after(Node *np, Node *after);
	int extract(Node *np);
	void remove(Node *np);
	void show();
	long size();

	Node *operator [](int n);
};

#endif

