/* \file strtoken.cpp
*
*/
#include <stdio.h>
#include <stdlib.h>

//! skips whitespace and returns next token (or null pointer)
/*!
 * \param str is input c-string (modified to point to character after
 * delimiter
 * \param delimiter marks the end of a token (usually a blank)
 * \retval c-string pointing to start of delimiter.
 * The delimiter character in the input string is replaced by a null
 * character.
 */

char *strtoken(char* &str, char delimiter)
{
	//char *str = *inp;
	if (str==0) return 0;
	while (*str == ' ') str++; // skip whitespace
	//*inp = str;
	if (*str==0) return 0;
	char *token = str;
	while (*str && *str!=delimiter) str++;
	if (*str) *str++ = 0; // substitute null for delimiter to terminate token
	//*inp = str;
	return token;
}


//! terminates string at specified character
/*! This routine terminates a string at the specified character and
*   returns a c-string pointer to the character following the delimiter.
*   @param str input c-string
*   @param delimiter token delimiter character
*   @retval c-string to character following the delimiter
*
*   For example: Suppose the string str = "name=value";
*   then char * token = strtrm(str,"=");
*   would return "value" as the token, but str would now be "name" since
*   the character '=' is replaced by a null.
*/

char *strtrm(char *str, char delimiter)
{
	if (str==0) return 0;
	while (*str && *str!=delimiter) str++;
	if (*str==0) return 0;
	*str++ = 0;
	return str;
}


//! count occurences of specified character in a string.

int strcnt(char *str, char delimiter)
{
	int n = 0;
	while (*str) {
		if (*str++ == delimiter) n++;
	}
	return n;
}

//! return pointer to character after delimiter, ignoring quoted text
/*!
 *  This routine returns a pointer (c-string) to character after the
 *  delimiter, ignoring text between quotes. Returns null if delimiter not found.
*/

char *strqtrm(char *str, char delimiter)
{
	if (str==0) return 0;
	while (*str && *str!=delimiter) {
		if (*str=='\"') {
			str++;
			while (*str && *str!='\"') str++;
			if (*str==0) return 0;
		}
		str++;
	}
	if (*str==0) return 0;
	*str++ = 0;
	return str;
}


//!  convert two digit hex string to an ASCII character

char x2c(char *str)
{
	char digit;
	/* The operation (*str & 0xdf) converts lower case to upper case */
	digit = (*str >= 'A' ? ((*str & 0xdf) - 'A')+10 : (*str - '0'));
	digit *= 16;
	str++;
	digit += (*str >= 'A' ? ((*str & 0xdf) - 'A')+10 : (*str - '0'));
	return(digit);
}

//! convert '+' to ' ' and two digit hex escape sequences to ASCII character

void unescape_url(char *url)
{
	char *cp;
	for (cp=url; *url; cp++, url++) {
		if (*url == '+') *cp = ' ';
		else if (*url == '%') {
			*cp = x2c(url+1);
			url += 2;
		}
		else *cp = *url;
	}
	*cp = '\0';
}
