/* \file numbers.cpp
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <iostream>
#include <string>
using namespace std;
#include "strtoken.h"

void parse(FILE *in, FILE *out);

int main(int argc, char *argv[])
{
	FILE *in, *out;
	string filename;
	errno_t nerr;
	if (argc<2) {
		cout << "usage: numbers file\n";
		return EXIT_FAILURE;
	}
	filename = argv[1];
	nerr = fopen_s(&in,filename.c_str(),"r");
	if (nerr) {
		cout << "file: " << filename << " not found\n";
		return EXIT_FAILURE;
	}
	if (argc<3) out = stdout;
	else {
		filename = argv[2];
		nerr = fopen_s(&out,filename.c_str(),"wt");
		if (nerr) {
			cout << "file: " << filename << " creation error\n";
			return EXIT_FAILURE;
		}
	}
	parse(in,out);
	fclose(in);
	return EXIT_SUCCESS;
}

int decode(string token, int &value)
{
	//string cmd[] = { "HALT", "LW", "SW", "LI", "LUI"};
	//int ncmd = 5;
	int n;
	n = token.find("0x");
	if (n>=0) n = sscanf_s(token.c_str(),"%x",&value);
	else n = sscanf_s(token.c_str(),"%d",&value);
	return n;
}

void convert_to_lower(char *buf)
{
	char *inp;
	for (inp=buf; *inp; inp++) {
		if (isupper(*inp)) *inp = (char) tolower(*inp);
	}
}
	



void parse(FILE *in, FILE *out)
{
	char buf[512];
	char *inp, *next;
	int value;
	int count, n;
	string token;
	bool done = false;
	/*
	 * Go through input file, line by line
	 */
	n = 0;
	while (!done) {
		fgets(buf,511,in);
		if (feof(in)) break;
		fprintf(out,"%s",buf);
		if (*buf=='#') continue;
		next = buf;
		/*
		 * parse current line
		 */
		count = 0;
		while (next) {
			inp = next;
			next = strqtrm(inp,',');
			convert_to_lower(inp);
			token = inp;
			n = decode(token,value);
			if (n>0) fprintf(out,"%s is %d\n",token.c_str(),value);
			else fprintf(out,"%s is not a number\n",token.c_str());
		}
	}
}
