#include <stdio.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <iostream>
#include <string>
using namespace std;
#include "mips.h"
#include "opcodes.h"


char * opname[] = {
	"REGF","","j","jal","beq","bne","blez","bgtz","addi",
	"addiu","slti","sltiu","andi","ori","xori","lui","",
	"","","","","","","","",
	"","","","","","","","lb",
	"lh","lwl","lw","lbu","lhu","lwr","","sb",
	"sh","swl","sw","","","swr"
};


char * funcname[] = {
	"sll","","srl","sra","sllv","","srlv","srav","jr",
	"jalr","","","","","","","mfhi",
	"mthi","mflo","mtlo","","","","","mult",
	"multu","div","divu","","","","","add",
	"addu","sub","subu","and","or","xor","nor","",
	"slt","sltu"
};

char * extname[] = { "bltz", "bgez" };


int opcode(string str)
{
	const int na = sizeof(opname)/sizeof(opname[0]);
	int n;
	for (n=1; n<na; n++) {
		char *test = opname[n];
		if (*test==0) continue;
		if (str.compare(test)==0) return n;
	}
	return -1;
}

int fncode(string str)
{
	const int nb = sizeof(funcname)/sizeof(funcname[0]);
	int n;
	for (n=0; n<nb; n++) {
		char *test = funcname[n];
		if (*test==0) continue;
		if (str.compare(test)==0) return n;
	}
	return -1;
}

int ecode(string str)
{
	const int nc = 2;
	int n;
	for (n=0; n<nc; n++) {
		char *test = extname[n];
		if (str.compare(test)==0) return n;
	}
	return -1;
}



int is_branch_or_jump(string str)
{
	int n = opcode(str);
	switch (n) {
	case BEQ: 
	case BGTZ:
	case BLEZ:
	case BNE:
		return 1;
	case J:
	case JAL:
		return 2;
	}
	n = fncode(str);
	switch (n) {
	case JALR:
	case JR:
		return 2;
	}
	n = ecode(str);
	if (n>=0) return 1;
	return 0;
}

int iform(int opcode, int arg[4])
{
	mips_format_t ia;
	ia.w = 0;
	ia.op = opcode;
	switch (opcode) {
	case BEQ:
	case BNE:
	case BGTZ:
	case BLTZ:
		ia.rs = arg[0];
		ia.rt = arg[1];
		break;
	case JAL:
	case J:
		ia.w = ia.w | (arg[0]&0x3FFFFFF);
		return ia.w;
	default:
	ia.rs = arg[1];
		ia.rt = arg[0];
	}
	ia.immed = arg[2];
	return ia.w;
}

int rform(int code, int arg[4])
{
	mips_format_t ia;
	ia.w = 0;
	ia.op = 0;
	switch (code) {
	case JR:
		ia.rs = arg[0];
		break;
	case JALR:
		ia.rs = arg[0];
		ia.rd = arg[1]>0? arg[1]: 31;
		break;
	default:
		ia.rs = arg[1];
		ia.rt = arg[2];
		ia.rd = arg[0];
		break;
	}
	ia.sh = arg[3];
	ia.fn = code;
	return ia.w;
}

int eform(int code, int arg[4])
{
	mips_format_t ia;
	ia.op = 1;
	ia.rs = arg[0];
	ia.rt = code;
	ia.immed = arg[1];
	return ia.w;
}
	

#if defined(__TEST__)

int test1()
{
	int i, k;
	mips_format_t ia;
	unsigned int codes[] = {0x27bdffe8, 0xAFBE0010, 0x03A0F021, 0x2402000E};
	int n = sizeof(codes)/sizeof(int);
	for (i=0; i<n; i++) {
		ia.w = codes[i];
		printf("\ninstruction: %X\n",ia.w);
		k = ia.opcode;
		printf("opcode: %X %s\n",k,opname[k]);
		printf("rs: %d rt: %d\n", ia.rs, ia.rt);
		if (ia.opcode==0) {
			k = ia.fn;
			printf("rd: %d  sh: %d  fn: %X %s\n",ia.rd,ia.sh,k,funcname[k]);
		}
		else {
			printf("immed: %d\n",ia.immed);
		}
	}
	return 0;
}

int test2()
{
	mips_format_t ia;
	ia.opcode = 0;
	ia.rs = 2;
	ia.rt = 3;
	ia.rd = 4;
	ia.sh = 0;
	ia.fn = 0x08;
	printf("0x%08x\n",ia.w);
	return 0;
}

int main()
{
	test1();
}

#endif

