/* \file construct.cpp
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <iostream>
#include <string>
using namespace std;
#include "strtoken.h"

void parse1(FILE *in, FILE *out);
void parse2(FILE *in, FILE *out);

string opname[64], funcname[64];

int main(int argc, char *argv[])
{
	FILE *in, *out;
	string filename;
	errno_t nerr;
	if (argc<2) {
		cout << "usage: construct source [ outfile ]\n";
		return EXIT_FAILURE;
	}
	filename = argv[1];
	nerr = fopen_s(&in,filename.c_str(),"r");
	if (nerr) {
		cout << "file: " << filename << " not found\n";
		return EXIT_FAILURE;
	}
	if (argc<3) out = stdout;
	else {
		filename = argv[2];
		nerr = fopen_s(&out,filename.c_str(),"wt");
		if (nerr) {
			cout << "file: " << filename << " creation error\n";
			return EXIT_FAILURE;
		}
	}
	parse2(in,out);
	fclose(in);
	return EXIT_SUCCESS;
}

void convert_to_upper(char *buf)
{
	char *inp;
	for (inp=buf; *inp; inp++) {
		if (islower(*inp)) *inp = (char) toupper(*inp);
	}
}

bool is_empty(char *buf)
{
	if (!buf) return true;
	if (*buf==0) return true;
	return false;
}


void parse2(FILE *in, FILE *out)
{
	char buf[512];
	char *inp, *tok;
	int field, count, n;
	string token;
	bool done = false;
	/*
	 * Go through input file, line by line
	 */
	count = 0;
	fprintf(out,"localparam\n");
	while (!done) {
		fgets(buf,511,in);
		if (feof(in)) break;
		inp = buf;
		tok = strtoken(inp,',');
		n = sscanf_s(tok,"%x",&field);
		if (n<=0) continue;
		count++;
		tok = strtoken(inp,',');
		// opname
		if (!is_empty(tok)) {
			convert_to_upper(tok);
			fprintf(out,"%s = 6'h%02x,\n",tok,field);
		}
		tok = strtoken(inp,'\n');
		// func
		if (!is_empty(tok)) {
			convert_to_upper(tok);
			fprintf(out,"%s = 6'h%02x,\n",tok,field);
		}
	}
}

