/* asm.h
*
*
*/
#include "tag.h"


int opcode(string str);
int fncode(string str);
int ecode(string str);
int rform(int opcode, int arg[4]);
int iform(int fcode, int arg[4]);
int eform(int ecode, int arg[4]);

#if !defined(__ASM_H)
#define __ASM_H


class Operand: public Node {
	public:
		int type;
		int value;
		string ref;
		Operand() { }
		Operand(int ntype, int nvalue);
		~Operand() { }
		void show();
};

class Symbol: public Node {
	public:
		string name;
		int addr;
		Symbol() { }
		Symbol(string str) { name = str; }
		~Symbol() { }
		void show();
		int compare(string str) { return name.compare(str); }
};


class Instruction: public Node {
	public:
		string src;
		Symbol *label;
		string opname;
		List operands;
		int argtype;
		int addr;
		int value;
		Instruction() { label=NULL; }
		Instruction(char *name) { opname= name; label=NULL; }
		~Instruction() { operands.clear(); }
		void show();
		int code();
		int type();
		bool is_directive();
		void set_argtype();
		void swap121();
};


#endif