/* \file asm.cpp
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <iostream>
#include <string>
using namespace std;
#include "asm.h"

void Operand::show()
{
	printf("\t");
	switch (type) {
	case 1:
		printf("$%d",value);
		break;
	case 2:
		printf("%d",value);
		break;
	case 3:
		printf("%s",ref.c_str());
		//printf("%s [0x%x]",ref.c_str(),value);
		break;
	default:
		break;
	}
		
 }

Operand::Operand(int ntype, int nvalue)
{
	type = ntype;
	value = nvalue;
}

int Instruction::type()
{
	if (opname.empty()) return -1;
	const char *it = opname.c_str();
	if (*it=='.') return 0; // is_directive
	return 1;
}

bool Instruction::is_directive()
{
	if (!opname.empty()) {
		const char *it = opname.c_str();
		if (*it=='.') return true;
	}
	return false;
}

void Instruction::show()
{
	int nt = type();
	if (nt>0) printf("%04x\t%08x  ",addr,value);
	else printf("    \t          ");
	if (label) printf("%s:",label->name.c_str());
	printf("\t");
	printf("%s",opname.c_str());
	operands.show();
	nt = 3 - operands.count();
	while (nt--) printf("\t");
	/*
	if (argtype!=9 && argtype>0) printf("\t(%d)\n",argtype);
	else printf("\n");
	*/
	printf("\t|  %s\n",src.c_str());
}

int Instruction::code()
{
	int n, m, arg[4], val;
	Node *np;
	Operand *op;
	if (opname.compare("nop")==0) return 0;
	for (m=0; m<4; m++) arg[m] = 0;
	m = 0;
	for (np=operands.first(); np; np=np->next) {
		op = (Operand *) np;
		val = op->value;
		arg[m++] = val;
	}
		
	n = opcode(opname);
	if (n>0) return iform(n,arg);
	n = fncode(opname);
	if (n>0) return rform(n,arg);
	n = ecode(opname);
	if (n>=0) return eform(n,arg);
	printf("\nunrecognized instruction: %s\n",opname.c_str()); 
	return 0;
}

void Instruction::set_argtype()
{
	Node *np;
	argtype = 0;
	for (np = operands.first(); np; np=np->next) {
		Operand *op = (Operand *) np;
		argtype = argtype*10 + op->type;
	}
}

void Instruction::swap121()
{
	Node *np;
	np = operands[1];
	operands.extract(np);
	operands.append(np);
	argtype = 112;
}

void Symbol::show()
{
	printf("%04x %s\n",addr,name.c_str());
}
