/* \file dasm.cpp
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <iostream>
#include <string>
using namespace std;
#include "strtoken.h"
#include "asm.h"

List code;


void parse(FILE *in);
void pseudo(Node *np);

int main(int argc, char *argv[])
{
	FILE *in, *out;
	string filename;
	errno_t nerr;
	if (argc<2) {
		cout << "usage: dasm source [ outfile ]\n";
		return EXIT_FAILURE;
	}
	filename = argv[1];
	nerr = fopen_s(&in,filename.c_str(),"r");
	if (nerr) {
		cout << "file: " << filename << " not found\n";
		return EXIT_FAILURE;
	}
	if (argc<3) out = stdout;
	else {
		filename = argv[2];
		nerr = fopen_s(&out,filename.c_str(),"wt");
		if (nerr) {
			cout << "file: " << filename << " creation error\n";
			return EXIT_FAILURE;
		}
	}
	parse(in);
	fclose(in);

	code.show();
	
	Node *np;
	// process pseudo instructions
	for (np=code.first(); np; np=np->next) pseudo(np);

	// output
	int n, count;
	bool binary=false;
	count = 0;
	for (np=code.first(); np; np=np->next) {
		Instruction *ip = (Instruction *) np;
		if (ip->opname.empty()) continue;
		if (ip->is_directive()) {
			if (count>0) {
				fprintf(out,"\n");
				count=0;
			}
			if (ip->opname.compare(".text")==0) fprintf(out,"inst\n");
			else if (ip->opname.compare(".data")==0) fprintf(out,"data\n");
			else if (ip->opname.compare(".end")==0) fprintf(out,"end\n");
			continue;
		}
		n = ip->code();
		if (n) {
			if (binary) fwrite(&n,4,1,out);
			else {
				fprintf(out,"%08x ",n);
				if (count%8==7) fprintf(out,"\n");
			}
			count++;
		}
		else {
			printf("\nUnrecognized instruction:\n");
			ip->show();
		}
	}
	if (!binary) fprintf(out,"\n");
/*
	while (count < 32) {
		fprintf(out,"00000000 ");
		if (count%8==7) fprintf(out,"\n");
		count++;
	}
	fprintf(out,"\n");
*/
	//code.show();
	return EXIT_SUCCESS;
}

int is_blank(char *buf)
{
	while (*buf) {
		if (*buf++ != ' ') return 0;
	}
	return 1;
}

int decode_register(char *token, int &field)
{
	while (*token==' ') token++;
	if (*token!='$' && *token!='r') return -1;
	sscanf_s(++token,"%d",&field);
	return 1;
}

int decode_number(string token, int &value)
{
	int n;
	n = token.find("0x");
	if (n>=0) n = sscanf_s(token.c_str(),"%x",&value);
	else n = sscanf_s(token.c_str(),"%d",&value);
	return n;
}


void parse(FILE *in)
{
	char buf[512];
	char *inp, *next, *tok;
	int field, count, n;
	string token;
	bool done = false;
	/*
	 * Go through input file, line by line
	 */
	n = 0;
	while (!done) {
		fgets(buf,511,in);
		if (feof(in)) break;
		for (inp=buf; *inp; inp++) {
			if (*inp=='\t') *inp = ' ';
			if (*inp=='\n') *inp = 0;
			if (*inp=='(') *inp = ',';
		}
		strqtrm(buf,'#');
		//printf("%s\n",buf);
		if (is_blank(buf)) continue;
		next = buf;
		/*
		 * parse current line
		 */
		count = 0;
		Instruction* ins = new Instruction;
		code.append(ins);
		ins->src = buf;
		while (next) {
			inp = next;
			// check for label
			next = strqtrm(inp,':');
			if (next) {
				strtrm(inp,' ');
				token = inp;
				ins->label = token;
				//fprintf(out,"label %s (%d)\n",inp,label.length());
			}
			else {
				token = "";
				next = inp;
			}
			tok = strtoken(next,' ');
			if (tok) {
				//printf("operation %s\n",tok);
				ins->opname = tok;
			}
			while (next) {
				inp = next;
				next = strqtrm(inp,',');
				Operand *op  = new Operand;
				ins->operands.append(op);
				n = decode_register(inp,field);
				if (n>0) {
					//printf("register r%d\n",field);
					op->type = 1;
					op->value = field;
				}
				else {
					token = inp;
					n = decode_number(token,field);
					if (n>0) {
						//printf("number %d\n",field);
						op->type = 2;
						op->value = field;
					}
					else if (*inp) {
						tok = strtoken(inp,' ');
						if (tok) {
							op->type = 3;
							op->ref = tok;
							//printf("reference %s (%d)\n",tok,strlen(tok));
						}
						else op->type = 9;
					}
					else op->type = 9;
				}
			}
		}
	}
	Node *np;
	for (np=code.first(); np; np=np->next) {
		Instruction *ip = (Instruction *) np;
		ip->set_argtype();
		if (ip->argtype==121) ip->swap121();
	}
}

void pseudo(Node *np)
{
	Instruction *ip = (Instruction *) np;
	Operand *op;
	if (ip->opname.compare("li")==0) {
		op = (Operand *) ip->operands.last();
		op = new Operand;
		op->type = 1;
		op->value = 0;
		ip->operands.insert(op,1);
		ip->opname = "ori";
	}
	else if (ip->opname.compare("b")==0) {
		ip->operands.clear();
		ip->opname = "bgez";
	}
}
		
		
		
/*
		if (!label.empty())
			fprintf(out,"label: %s %d\n",label.c_str(),label.length());

		if (opcode==0) {
			fprintf(out,"0000");
		}
		else  {
			if (opcode<0) opcode = 0;
			code = (opcode<<11) | ((rd&0x7)<<8) | (ra&0xFF);
			fprintf(out,"%04X",code);
		}
		if (n%8==7) fprintf(out,"\n");
		else fprintf(out," ");
		n++;

	}

	while (n < 32) {
		fprintf(out,"0000");
		if (n%8==7) fprintf(out,"\n");
		else fprintf(out," ");
		n++;
	}
	fprintf(out,"\n");
}
*/
