`timescale 1ns/1ps
module test_register;
  parameter WIDTH=4;
  
  reg [WIDTH-1:0] D;
  reg CLK, LOAD, CLR;
  wire [WIDTH-1:0] Q;
  
  register r1(Q,D,CLK,LOAD,CLR);
  
  initial
    begin
      $display("t clk load clr   D Q");
      CLK = 1'b0;
      LOAD = 1'b1;
      CLR = 1'b1;
      D = 4'h0;
  end
  
integer ii;
  initial
    for (ii=0; ii<40; ii=ii+1)
      #1 CLK <= ~CLK;
  
always @(posedge CLK)
  D <= D + 1'b1;
    

initial
  begin
      #5 LOAD <= 1'b0;
      #10 LOAD <= 1'b1;
      #2 LOAD <= 1'b0;
      #9 CLR <= 1'b0;
      #2 CLR <= 1'b1;
  end
  
  
  initial
    $monitor("%0d    %b    %b    %b    %x %x",
      $time,CLK,LOAD,CLR,D,Q);

endmodule

