module ramtest 
#(parameter DATA_WIDTH=8, parameter ADDR_WIDTH=6)
(
    input clk, reset_n,
    output [(ADDR_WIDTH-1):0] addr,
    output we,
    output  [(DATA_WIDTH-1):0] q, qa,
    output reg [ADDR_WIDTH-1:0] pc,
    output [(DATA_WIDTH-1):0] inst
);

defparam dev1.DATA_WIDTH = DATA_WIDTH, dev1.ADDR_WIDTH=ADDR_WIDTH;

single_port_ram dev1
(
    .data(qa),
    .addr(addr),
    .we(we),
    .clk(clk),
    .q(q)
);

reg [1:0] state;
localparam HALT = 2'h3, IF = 2'h1, EX=2'h2;

wire [ADDR_WIDTH-1:0] nextpc = pc + 1'b1;
assign addr = state==EX? q[ADDR_WIDTH-1:0]: nextpc;

assign we = state==EX? inst[6]: 1'b0;

// define latches
assign qa = state==IF? q: qa;
assign inst = state==EX? q: inst;

always @(posedge clk or negedge reset_n)
begin
	if (!reset_n)
	begin
		pc <= 6'h3F;
		state = IF;
	end
	else
	case (state)
	IF:
	begin
	   pc <= nextpc;
	   state <= EX;
	end
	EX:
	begin
	   if (inst==0) state <= HALT;
	   else state <= IF;
	end
	HALT:
	begin
	   pc <= 6'h3F;
	   state <= HALT;
	end
	default:
	   state <= HALT;
	endcase
end

endmodule




