`timescale 1ns/1ps
module ramtestbench;

reg clk, reset_n;
wire [7:0] q, qa, inst;
wire [5:0] addr,pc;
wire we;
wire [1:0] state;
 
ramtest u(clk,reset_n,addr,we,q,qa,pc,inst,state);

initial
  begin
    $display("   t reset_n clk addr    q   pc   qa inst   we state");
    reset_n = 1'b0;
    #2 reset_n = 1'b1;
    #52 reset_n = 1'b0;
    #2 reset_n = 1'b1;
  end

integer ii;
initial
   begin
     clk = 1'b0;
     for (ii=0; ii<40; ii=ii+1)
      begin
        #1 clk = 1'b1;
        #1 clk = 1'b0;
    end
  end



initial
  $monitor("%4g %7b %3b %4x %4x %4x %4x %4x %4b %5x",
     $realtime,reset_n, clk, addr, q, pc, qa, inst, we, u.state);

endmodule