module memlab2(
  // Clock Input (50 MHz)
  input  CLOCK_50,
  //  Push Buttons
  input  [3:0]  KEY,
  //  DPDT Switches 
  input  [17:0]  SW,
  //  7-SEG Displays
  output  [6:0]  HEX0, HEX1, HEX2, HEX3, HEX4, HEX5, HEX6, HEX7,
  //  LEDs
  output  [8:0]  LEDG,  //  LED Green[8:0]
  output  [17:0]  LEDR //  LED Red[17:0]
);

// Connect dip switches to red LEDs
assign LEDR[17:0] = SW[17:0];

// turn off green LEDs
assign LEDG[8:3] = 0;

// define reset

wire RST;
assign RST = KEY[0];


// clock definition

wire [6:0] myclock;
wire clk;
clock_divider cdiv(CLOCK_50,RST,myclock);
assign clk = SW[17]? ~KEY[3]: myclock[0];

// instantiate and connect memory

wire we;
wire [5:0] pc, addr;
wire [7:0] q, qa, inst;

wire [1:0] state;
assign LEDG[0] = state==2'h1;
assign LEDG[1] = state==2'h2;
assign LEDG[2] = state==2'h3;

ramtest ut(
  .clk(clk), .reset_n(RST),
  .addr(addr), .we(we),
  .q(q), .qa(qa), .pc(pc),
  .inst(inst), .present(state)
); 

// map to 7-segment displays

hex_7seg dsp0(inst[3:0],HEX0);
hex_7seg dsp1(inst[7:4],HEX1);
hex_7seg dsp2(qa[3:0],HEX2);
hex_7seg dsp3(qa[7:4],HEX3);
hex_7seg dsp4(q[3:0],HEX4);
hex_7seg dsp5(q[7:4],HEX5);
hex_7seg dsp6(addr[3:0],HEX6);
hex_7seg dsp7({2'b00,addr[5:4]},HEX7);


localparam blank = ~7'h00; 


endmodule