module memlab1(
  // Clock Input (50 MHz)
  input  CLOCK_50,
  //  Push Buttons
  input  [3:0]  KEY,
  //  DPDT Switches 
  input  [17:0]  SW,
  //  7-SEG Displays
  output  [6:0]  HEX0, HEX1, HEX2, HEX3, HEX4, HEX5, HEX6, HEX7,
  //  LEDs
  output  [8:0]  LEDG,  //  LED Green[8:0]
  output  [17:0]  LEDR //  LED Red[17:0]
);

// Connect dip switches to red LEDs
assign LEDR[17:0] = SW[17:0];

// turn off green LEDs
assign LEDG[8:0] = 0;

// instantiate and connect memory

wire D,S,Q1,Q2;
assign D = SW[0];
assign S = SW[17];
latch2 u1(D,S,Q1);
flipflop u2(Q2,D,S);

// map to 7-segment displays

hex_7seg dsp0({3'h0,Q1},HEX0);
hex_7seg dsp1({3'h0,Q2},HEX1);


localparam blank = ~7'h00; 

// blank remaining digits
assign HEX2 = blank;
assign HEX3 = blank;
assign HEX4 = blank;
assign HEX5 = blank;
assign HEX6 = blank;
assign HEX7 = blank;

endmodule