module bcdlab(
  // Clock Input (50 MHz)
  input  CLOCK_50,
  //  Push Buttons
  input  [3:0]  KEY,
  //  DPDT Switches 
  input  [17:0]  SW,
  //  7-SEG Displays
  output  [6:0]  HEX0, HEX1, HEX2, HEX3, HEX4, HEX5, HEX6, HEX7,
  //  LEDs
  output  [8:0]  LEDG,  //  LED Green[8:0]
  output  [17:0]  LEDR //  LED Red[17:0]
);

// Connect dip switches to red LEDs
assign LEDR[17:0] = SW[17:0];

// turn off green LEDs
assign LEDG[8:0] = 0;

// binary to BCD
wire [19:0] BCD;
div10 u1(SW[15:0],BCD);

// map to 7-segment displays

hex_7seg dsp0(BCD[3:0],HEX0);
hex_7seg dsp1(BCD[7:4],HEX1);
hex_7seg dsp2(BCD[11:8],HEX2);
hex_7seg dsp3(BCD[15:12],HEX3);
hex_7seg dsp4(BCD[19:16],HEX4);

localparam blank = ~7'h00; 

// blank remaining digits
assign HEX5 = blank;
assign HEX6 = blank;
assign HEX7 = blank;

endmodule