module test_barrel;
  
  reg [31:0] inp;
  reg [2:0] control;
  reg [4:0] shift;
  wire [31:0] out,out1,out2;

localparam
    sll = 3'b000,
	  srl = 3'b001,
	  sra = 3'b011,
	  rol = 3'b100,
	  ror = 3'b101;
	
	barrel6 u6(inp,control,shift,out);
	barrel5 u5(inp,control,shift,out1);
	barrel1 u1(inp,control,shift,out2);
	
	wire test1 = (out==out1);
	wire test2 = (out==out2);
	
	integer n;
	initial
	   begin
	     control = sll;
	     $display("shift left");
	     inp = 32'h0000000F;
	     $display("\n t shft    value");
	     for (n=0; n<32; n=n+1)
	     begin
	       shift = n;
	       #1;
	     end
	     control = srl;
	     $display("shift right");
	     inp = 32'h7E000000;
	     $display("\n t shft    value");
	     for (n=0; n<32; n=n+1)
	     begin
	       shift = n;
	       #1;
	     end
	     control = sra;
	     $display("shift right arithmetic");
	     inp = 32'h80000000;
	     $display("\n t shft    value");
	     for (n=0; n<32; n=n+1)
	     begin
	       shift = n;
	       #1;
	     end
	     control = ror;
	     $display("rotate right");
	     inp = 32'hF0A0B0D0;
	     $display("\n t shft    value");
	     for (n=0; n<32; n=n+1)
	     begin
	       shift = n;
	       #1;
	     end
	     control = rol;
	     $display("rotate left");
	     inp = 32'hA0B0C0D0;
	     $display("\n t shft    value");
	     for (n=0; n<32; n=n+1)
	     begin
	       shift = n;
	       #1;
	     end
	   end
	
	
	
	initial
	   $monitor("%0d   %d    %x  %b %b   %x",$time,shift,out,test1,test2,out2);


endmodule
