// behavioral version

module barrel1(
input [31:0] inp,
input [2:0] control,
input [4:0] shift,
output reg [31:0] out
);

wire [5:0] shfc = 32 - shift;

localparam
    sll = 3'b000,
	  srl = 3'b001,
	  sra = 3'b011,
	  rol = 3'b100,
	  ror = 3'b101;


//wire [31:0] se = (inp[31]? 32'hFFFFFFFF: 32'h00000000);
wire [31:0] se = {32{inp[31]}};

always @(*)
case (control)
sll:
	out <= (inp<<shift);
srl:
	out <= (inp>>shift);
sra:
	out <= (inp>>shift)|(se<<shfc);
rol:
  out <= (inp<<shift)|(inp>>shfc);
ror:
  out <= (inp>>shift)|(inp<<shfc);
default:
	out <= inp;
endcase

endmodule