`timescale 1ns/1ps
module adder_test;
reg a, b, c;
wire sum,cout,test;
wire [1:0] w;

assign w = a+b+c;
full_adder fa(a,b,c,sum,cout);
assign test = (w=={cout,sum});

integer n1, n2, n3;
initial
begin
  $display("time c b a sum cout test");
  for (n1=0; n1<2; n1=n1+1)
    for (n2=0; n2<2; n2=n2+1)
      for (n3=0; n3<2; n3=n3+1)
      begin
        a <= 1'bx;
        b <= 1'bx;
        c <= 1'bx;
        #0.1;
        a <= n3;
        b <= n2;
        c <= n1;
        #0.9;
      end
end

initial
	$monitor("%0g %b %b %b    %b %b %s",
		$realtime,c,b,a,sum,cout,(test? "ok":"invalid"));
endmodule
