`timescale 1ns/1ps
module fourbit_test;
parameter WIDTH=4;
reg [WIDTH-1:0] a, b; 
wire cin=1'b0;
wire [WIDTH-1:0] sum;
wire cout,test;
wire [WIDTH:0] w;

assign w = a+b+cin;
defparam fa.WIDTH = WIDTH;
fourbit_adder2 fa(a,b,cin,sum,cout);
assign test = (w=={cout,sum});

integer n1, n2, N;
initial
begin
  N = 2**WIDTH;
  $display("time b a sum cout test");
  for (n1=0; n1<N; n1=n1+1)
    for (n2=0; n2<N; n2=n2+1)
      begin
        a <= n2;
        b <= n1;
        #1;
      end
end

initial
	$monitor("%0g %d %d     %d %b  %s",
		$realtime,b,a,sum,cout,(test? "ok":"invalid"));
endmodule
