module fourbit_adder2
#(parameter WIDTH=8)(
input [WIDTH-1:0] a,b,
input cin,
output [WIDTH-1:0] sum,
output cout
);
wire [WIDTH:0] carry;
assign carry[0] = cin;
assign  cout = carry[WIDTH];
genvar N;
generate
  for (N=0; N<WIDTH; N=N+1)
  begin: bit
	full_adder fa(a[N],b[N],carry[N],sum[N],carry[N+1]);
	end
endgenerate
endmodule
