module alu_test;
  
parameter N = 3;

reg  [N-1:0] a, b;
wire  [N-1:0] c;
wire zero, neg, ovfl, cout;
reg [1:0] control;

defparam u1.N = N;
alu u1(a,b,control,c,zero,neg,ovfl,cout);


integer mA, mB, mC, M, Ms;
wire test1 = (c!=mC)==ovfl;
wire test2 = (mC<0)==neg;
wire test3 = (mC==0)==zero;
initial
begin
  control = 2'b10;
  M = control[1]? 2**N: 2**(N-1);
  Ms = control[1]? 0: -M;
  $display("%ssigned addition",control[1]?"un":"");
  $display("t a b  c  cmp     test");
  for (mA=Ms; mA<M; mA=mA+1)
    for (mB=Ms; mB<M; mB=mB+1)
    begin
      a = mA;
      b = mB;
      mC = mA+mB;
      #1;
    end
  control[0] = 1'b1;
  $display("%ssigned subtraction",control[1]?"un":"");
  $display("t a b  c  cmp     test");
  for (mA=Ms; mA<M; mA=mA+1)
      for (mB=Ms; mB<M; mB=mB+1)
    begin
      a = mA;
      b = mB;
      mC = mA-mB;
      #1;
    end
end
initial
    $monitor("%0d %d %d %d   %4d      %b%b%b",
      $time,a,b,c,mC,test1,test2,test3);
endmodule
