/*
*   control:
*    00  add, signed
*    01  subtract, signed
*    10  add, unsigned
*    11  subtract, unsigned
*/  
module alu
#(parameter N=32)(
input [N-1:0] a,b,
input [1:0] control,
output [N-1:0] c,
output zero,neg,ovfl,cout
);

wire [N-1:0] bt;
wire subtract = control[0];
wire notsigned = control[1];
assign bt = subtract? ~b: b;
assign {cout, c} = a+bt+subtract;


wire sgn, unsgn;
wire an = a[N-1];
wire bn = bt[N-1];
wire cn = c[N-1];
assign sgn  = (cn? (~an)&(~bn): an&bn);
assign unsgn = cout^subtract;
assign ovfl = (notsigned? unsgn: sgn);
assign neg = (notsigned? unsgn&subtract: cn^ovfl);
assign zero = (~|c)&~ovfl;

endmodule


