module sys2(
  // Clock Input (50 MHz)
  input  CLOCK_50,
  //  Push Buttons
  input  [3:0]  KEY,
  //  DPDT Switches 
  input  [17:0]  SW,
  //  7-SEG Displays
  output  [6:0]  HEX0, HEX1, HEX2, HEX3, HEX4, HEX5, HEX6, HEX7,
  //  LEDs
  output  [8:0]  LEDG,  //  LED Green[8:0]
  output  [17:0]  LEDR,  //  LED Red[17:0]
//	LCD Module 16X2
   inout  [7:0]	LCD_DATA,	//	LCD Data bus 8 bits
   output		LCD_ON,		//	LCD Power ON/OFF
   output		LCD_BLON,	//	LCD Back Light ON/OFF
   output		LCD_RW,		//	LCD Read/Write Select, 0 = Write, 1 = Read
   output		LCD_EN,		//	LCD Enable
   output		LCD_RS,		//	LCD Command/Data Select, 0 = Command, 1 = Data

//		SDRAM Interface
   inout  [15:0] DRAM_DQ,	//	SDRAM Data bus 16 Bits
   output [11:0] DRAM_ADDR,	//	SDRAM Address bus 12 Bits
   output		DRAM_LDQM,	//	SDRAM Low-byte Data Mask 
   output		DRAM_UDQM,	//	SDRAM High-byte Data Mask
   output		DRAM_WE_N,	//	SDRAM Write Enable
   output		DRAM_CAS_N,	//	SDRAM Column Address Strobe
   output		DRAM_RAS_N,	//	SDRAM Row Address Strobe
   output		DRAM_CS_N,	//	SDRAM Chip Select
   output		DRAM_BA_0,	//	SDRAM Bank Address 0
   output		DRAM_BA_1,	//	SDRAM Bank Address 0
   output		DRAM_CLK,	//	SDRAM Clock
   output		DRAM_CKE,	//	SDRAM Clock Enable

  //  GPIO Connections
  inout  [35:0]  GPIO_0, GPIO_1
);

//  set all inout ports to tri-state
assign	DRAM_DQ		=	16'hzzzz;
assign  GPIO_0    =  36'hzzzzzzzzz;
assign  GPIO_1    =  36'hzzzzzzzzz;

wire RST;
assign RST = KEY[0];

// Connect dip switches to red LEDS
assign LEDR[17:0] = SW[17:0];

//	LCD ON
assign	LCD_ON		=	1'b1;
assign	LCD_BLON	=	1'b1;


wire [31:0] inport, outport;
assign inport[20:18] = KEY[3:1];
assign inport[17:0] = SW;
assign inport[31:21] = 0;
//assign outport = inport;

// map to 7-segment displays
wire  [7:0] blank;
hex_7seg_blanking dsp7(outport[31:28],HEX7,1'b1,blank[7]);
hex_7seg_blanking dsp6(outport[27:24],HEX6,blank[7],blank[6]);
hex_7seg_blanking dsp5(outport[23:20],HEX5,blank[6],blank[5]);
hex_7seg_blanking dsp4(outport[19:16],HEX4,blank[5],blank[4]);
hex_7seg_blanking dsp3(outport[15:12],HEX3,blank[4],blank[3]);
hex_7seg_blanking dsp2(outport[11:8],HEX2,blank[3],blank[2]);
hex_7seg_blanking dsp1(outport[7:4],HEX1,blank[2],blank[1]);
hex_7seg_blanking dsp0(outport[3:0],HEX0,blank[1],blank[0]);

sdram_pll pll(
	.inclk0(CLOCK_50),
	.c0(DRAM_CLK)
);



processor2 our_cpu(
// 1) global signals:
    .clk(CLOCK_50),
    .reset_n(RST),

// the_lcd
   .LCD_E_from_the_lcd(LCD_EN),
   .LCD_RS_from_the_lcd(LCD_RS),
   .LCD_RW_from_the_lcd(LCD_RW),
   .LCD_data_to_and_from_the_lcd(LCD_DATA),

 // the_sdram
   .zs_addr_from_the_sdram(DRAM_ADDR),
   .zs_ba_from_the_sdram({DRAM_BA_1,DRAM_BA_0}),
   .zs_cas_n_from_the_sdram(DRAM_CAS_N),
   .zs_cke_from_the_sdram(DRAM_CKE),
   .zs_cs_n_from_the_sdram(DRAM_CS_N),
   .zs_dq_to_and_from_the_sdram(DRAM_DQ),
   .zs_dqm_from_the_sdram({DRAM_UDQM,DRAM_LDQM}),
   .zs_ras_n_from_the_sdram(DRAM_RAS_N),
   .zs_we_n_from_the_sdram(DRAM_WE_N),

// the_pio_0
   .in_port_to_the_pio_0(inport),
   .out_port_from_the_pio_0(outport)

  );


//  output  [ 31: 0] out_port_from_the_pio_0;
//  input   [ 31: 0] in_port_to_the_pio_0;
endmodule