module reg_file(clock,da,db,dc,ra,rb,rc,write_enable,reset);
parameter BITS = 32;
input [BITS-1:0] dc;
output reg [BITS-1:0] da,db;
input [4:0] ra,rb,rc;
input clock, write_enable,reset;
reg [BITS-1:0] r[1:31];
integer i;

always @(posedge clock, negedge reset)
begin
	if (!reset)
		for (i=1; i<32; i=i+1) r[i] <= 0;
	else 
	begin
		if (write_enable && rc) r[rc] <= dc;
		da <= (ra? r[ra]: 0);
		db <= (rb? r[rb]: 0);
	end
end

/*
assign da = (ra? r[ra]: 0);
assign db = (rb? r[rb]: 0);
*/

endmodule			