// logarithmic shifter (base 2)
/*
*     control
*      00  nop  no operation
*      01  sll  shift left logical
*      10  srl  shift right logical
*      11  sra  shift right arithmetic
*/

module barrel(inp,control,shift,out);
input [31:0] inp;
input [1:0] control;
input [4:0] shift;
output [31:0] out;
reg [31:0] bit4,bit3,bit2,bit1,out;

parameter nop = 2'b00,
	  sll = 2'b01,
	  srl = 2'b10,
	  sra = 2'b11;

// bit 4 (16)
always
	if (shift[4])
	case (control)
	nop: bit4 = inp;
	sll: bit4 = {inp[15:0],16'h0000};
	srl: bit4 = {8'h0000,inp[31:16]};
	sra: bit4 = {(inp[31]? 16'hFFFF: 16'h0000),inp[31:16]};
	endcase
	else bit4=inp;
		
// bit 3 (8)
always
	if (shift[3])
	case (control)
	nop: bit3 = bit4;
	sll: bit3 = {bit4[23:0],8'h00};
	srl: bit3 = {8'h00,bit4[31:8]};
	sra: bit3 = {(bit4[31]? 8'hFF: 8'h00),bit4[31:8]};
	endcase
	else bit3 = bit4;

// bit 2 (4)
always
	if (shift[2])
	case (control)
	nop: bit2 = bit3;
	sll: bit2 = {bit3[27:0],4'b0000};
	srl: bit2 = {4'b0000,inp[31:4]};
	sra: bit2 = {(bit3[31]? 4'b1111: 4'b0000),bit3[31:4]};
	endcase
	else bit2 = bit3;

// bit 1 (2)
always
	if (shift[1])
	case (control)
	nop: bit1 = bit2;
	sll: bit1 = {bit2[29:0],2'b00};
	srl: bit1 = {2'b00,bit2[31:2]};
	sra: bit1 = {(bit2[31]? sra: 2'b00),bit2[31:2]};
	endcase
	else bit1 = bit2;

// bit 0 (1)
always
	if (shift[0])
	case (control)
	nop: out = bit1;
	sll: out = {bit1[30:0],1'b0};
	srl: out = {1'b0,bit1[31:1]};
	sra: out = {bit1[31],bit1[31:1]};
	endcase
	else out = bit1;

endmodule