// multiplexer version, still behavioral
/*
*     control
*     00  no operation
*     01  logical shift left
*     10  logical shift right
*     11  arithmetic shift right
*/


module barrel2(in,out,shamt,control);
input [31:0] in;
output [31:0] out;
input [4:0] shamt;
input [1:0] control;

reg [31:0] out;
wire [31:0] out1,out2;
assign out1 = (in<<shamt);
assign out2 = (in>>shamt);
wire [31:0] se;
assign se = {{31{in[31]}},1'b0};

always
case (control)
2'b00:
	out <= in;
2'b01:
	out <= out1;
2'b10:
	out <= out2;
2'b11:
	out <= out2 | (se<<~shamt);
default:
	out <= in;
endcase

endmodule