/*
*     control
*      000  sll  shift left logical
*      001  srl  shift right logical
*      011  sra  shift right arithmetic
*      100  rol  rotate left
*      101  ror  rotate right
*/

module barrel(inp,control,shift,out);
input [31:0] inp;
input [2:0] control;
input [4:0] shift;
output [31:0] out;
reg [31:0] bit4,bit3,bit2,bit1,out;

parameter sll = 3'b000,
	  srl = 3'b001,
	  sra = 3'b011,
	  rol = 3'b100,
	  ror = 3'b101;

// bit 4 (16)
always
	if (shift[4])
	case (control)
	sll: bit4 = {inp[15:0],16'h0000};
	srl: bit4 = {16'h0000,inp[31:16]};
	sra: bit4 = {(inp[31]? 16'hFFFF: 16'h0000),inp[31:16]};
	rol: bit4 = {inp[15:0],inp[31:16]};
	ror: bit4 = {inp[15:0],inp[31:16]};
	default: bit4 = inp;
	endcase
	else bit4=inp;
		
// bit 3 (8)
always
	if (shift[3])
	case (control)
	sll: bit3 = {bit4[23:0],8'h00};
	srl: bit3 = {8'h00,bit4[31:8]};
	sra: bit3 = {(bit4[31]? 8'hFF: 8'h00),bit4[31:8]};
	rol: bit3 = {bit4[23:0],bit4[31:24]};
	ror: bit3 = {bit4[7:0],bit4[31:8]};
	default: bit3 = bit4;
	endcase
	else bit3 = bit4;

// bit 2 (4)
always
	if (shift[2])
	case (control)
	sll: bit2 = {bit3[27:0],4'h0};
	srl: bit2 = {4'h0,bit3[31:4]};
	sra: bit2 = {(bit3[31]? 4'hf: 4'h0),bit3[31:4]};
	rol: bit2 = { bit3[27:0],bit3[31:28]};
	ror: bit2 = { bit3[3:0],bit3[31:4]};
	default: bit2 = bit3;
	endcase
	else bit2 = bit3;

// bit 1 (2)
always
	if (shift[1])
	case (control)
	sll: bit1 = {bit2[29:0],2'b00};
	srl: bit1 = {2'b00,bit2[31:2]};
	sra: bit1 = {(bit2[31]? 2'b11: 2'b00),bit2[31:2]};
	rol: bit1 = {bit2[29:0],bit2[31:30]};
	ror: bit1 = {bit2[1:0],bit2[31:2]};
	default: bit1 = bit2;
	endcase
	else bit1 = bit2;

// bit 0 (1)
always
	if (shift[0])
	case (control)
	sll: out = {bit1[30:0],1'b0};
	srl: out = {1'b0,bit1[31:1]};
	sra: out = {bit1[31],bit1[31:1]};
	rol: out = {bit1[30:0],bit1[31]};
	ror: out = {bit1[0],bit1[31:1]};
	default: out = bit1;
	endcase
	else out = bit1;

endmodule