module hex_7seg_blanking(
	input [3:0] hex_digit,
	output [6:0] seg, 
	input blank_in,
	output blank_out
);

reg [6:0] segm;
// segm = {g,f,e,d,c,b,a};
// 0 is on and 1 is off

always @ (hex_digit)
case (hex_digit)
		4'h0: segm = ~7'h3F;
		4'h1: segm = ~7'h06; 	// ---a----
		4'h2: segm = ~7'h5B; 	// |	  |
		4'h3: segm = ~7'h4F; 	// f	  b
		4'h4: segm = ~7'h66; 	// |	  |
		4'h5: segm = ~7'h6D; 	// ---g----
		4'h6: segm = ~7'h7D; 	// |	  |
		4'h7: segm = ~7'h07; 	// e	  c
		4'h8: segm = ~7'h7F; 	// |	  |
		4'h9: segm = ~7'h67; 	// ---d----
		4'ha: segm = ~7'h77;
		4'hb: segm = ~7'h7C;
		4'hc: segm = ~7'h39;
		4'hd: segm = ~7'h5E;
		4'he: segm = ~7'h79;
		4'hf: segm = ~7'h71;
endcase

wire [6:0] blank = ~7'h00;

assign blank_out = (hex_digit==4'b0000) && blank_in;
assign seg = (blank_out? blank: segm);

endmodule
