%% measure bow-tie coordinates


%%

clear
close all
load filelist
warning('off','images:initSize:adjustingMag');


%%

m = 6;
fname = files(m,:);
%m = 41;
rgb = imread(fname);
im = rgb2gray(im2double(rgb));
imshow(im);
clear rgb;

%%

h = filters2();
h0 = h(:,:,1);
h1 = h(:,:,2);
h2 = h(:,:,3);
h11 = h(:,:,4);
h22 = h(:,:,5);
h12 = h(:,:,6);

%% edges

a1 = imfilter(im,h1);
a2 = imfilter(im,h2);
bs = imfilter(im,h12);
bsmax = max(max(max(bs)),-min(min(bs)));

%% show vertices


c1 = a1/sum(sum(h1.^2));
c2 = a2/sum(sum(h2.^2));
c3 = bs/sum(sum(h12.^2));

xcen = -c2./c3;
ycen = -c1./c3;
rsq = xcen.^2+ycen.^2;
r = rsq<5;
g = zeros(size(im));
b = abs(bs)>0.2*bsmax;
imshow(cat(3,r,g,b));

%%
mask = and(r,b);
imshow(mask);

%%

% mask2 = zeros(size(im));
% idx = rect2(2)-1+(1:rect2(4));
% idy = rect2(1)-1+(1:rect2(3));
% mask2(idx,idy)=1;
% mask = mask.*mask2;
% xcen = xcen.*mask2;
% ycen = ycen.*mask2;

%% calculate vertices

sz = size(im);
xloc = ones(sz(1),1)*(1:sz(2));
yloc = (1:sz(1))'*ones(1,sz(2));
idx = find(mask(:)>0);
xcen=xcen(:);
xloc=xloc(:);
xpt = xloc(idx)+xcen(idx);
ycen=ycen(:);
yloc=yloc(:);
ypt = yloc(idx)+ycen(idx);
plot(xpt,ypt,'o');
axis ij


%% sort vertices

k = 0;
xw = xpt;
yw = ypt;
clear xc yc
while ~isempty(xw)
    test = (xw-xw(1)).^2+(yw-yw(1)).^2;
    [tsort idx] = sort(test);
    xw = xw(idx);
    yw = yw(idx);
    idx = find(tsort<64);
    k = k + 1;
    xc(k) = mean(xw(idx));
    yc(k) = mean(yw(idx));
    idx = find(tsort>64);
%     k
%     idx'
    xw = xw(idx);
    yw = yw(idx);
end
plot(xc,yc,'o');
axis ij

%% show results (on image)

imshow(im);
hold on
plot(xc,yc,'x','LineWidth',2,'MarkerSize',10);
hold off

%%

fprintf('size xc %d %d\n',size(xc));
xcen = mean(xc);
ycen = mean(yc);
fprintf('centroid %g %g\n',xcen,ycen);
hold on
plot(xcen,ycen,'mo','LineWidth',2,'MarkerSize',8);
hold off

%%

distsq = (xc-xcen).^2+(yc-ycen).^2;
[tsort idx] = sort(distsq);
if m==3 || m==4 || m==6
    idx(4)=idx(5);
end
idx = idx(1:4);
% hold on
% plot(xc(idx),yc(idx),'mo','LineWidth',2,'MarkerSize',10);
% hold off
[xcorn nx] = sort(xc(idx));
[ycorn ny] = sort(yc(idx));
ndx = idx(ny);
xs = xc(ndx(1));
ys = yc(ndx(1));
u = [xc(ndx(2))-xs yc(ndx(2))-ys];
v = [xc(ndx(3))-xc(ndx(2)) yc(ndx(3))-yc(ndx(2))];
width = norm(u);
d = dot(u,v)/(width*norm(v));
if abs(d)>0.5
    ndx(3:4) = fliplr(ndx(3:4));
end
v = [xc(ndx(4))-xc(ndx(1)) yc(ndx(4))-yc(ndx(1))];
height = norm(v);
fprintf('width %g height %g\n',width,height);
fprintf('tilt %g degrees\n',atan2(-u(2),u(1))*180/pi);
ndx(5) = ndx(1);
hold on
plot(xc(ndx),yc(ndx),'g','LineWidth',2,'MarkerSize',8);
hold off

%% 

drawgrid


%% sort points

% [tsort idx] = sort(xc);
% pts = zeros(3,3,2);
% pts(:,:,1) = reshape(tsort,3,3);
% pts(:,:,2) = reshape(yc(idx),3,3);
% for col=1:3
%     [pts(:,col,2) idx] = sort(pts(:,col,2));
%     pts(:,col,1) = pts(idx,col,1);
% end

%% widths

% width = diff(pts(:,:,1)')';
% ydiff = diff(pts(:,:,2)')';
% fprintf('%12s\t %12s\t %12s\t %12s\n','row','width 1','width 2','row angle');
% fprintf('%12s\t %12s\t %12s\t %12s\n','index','mm','mm','degrees');
% for n=1:3
%     c = polyfit(pts(n,:,1),pts(n,:,2),1);
%     fprintf('%12g\t %12g\t %12g\t %12g\n',floor(pts(n,1,2)),width(n,1),width(n,2),atan(c(1))*180/pi);
% end
% fprintf('\n\n');
% 
% fprintf('mean width %g pixels, std dev %g pixels\n\n\n',mean(width(:)),std(width(:)));

%% heights

% height = diff(pts(:,:,2));
% xdiff = diff(pts(:,:,1));
% fprintf('%12s\t %12s\t %12s\t %12s\n','col','height 1','height 2','col angle');
% fprintf('%12s\t %12s\t %12s\t %12s\n','index','mm','mm','degrees');
% for n=1:3
%     c = polyfit(pts(:,n,2),pts(:,n,1),1);
%     fprintf('%12g\t %12g\t %12g\t %12g\n',floor(pts(1,n,1)),height(1,n),height(2,n),atan(c(1))*180/pi);
% end
% fprintf('\n\n');
% 
% 
% fprintf('mean height %g pixels, std dev %g pixels\n\n\n',mean(height(:)),std(height(:)));


%% center position

% fprintf('center %g %g\n\n\n',pts(2,2,1:2));


%% show results (on image)

% imshow(im);
% hold on
% plot(xc,yc,'x','LineWidth',2,'MarkerSize',10);
% for k=1:3
%     for m=1:3
%         str = sprintf('%d, %d',k,m);
%         text(pts(k,m,1)+5,pts(k,m,2)+5,str,'color','y');
%     end
% end
% hold off







